<?php
/* --------------------------------------------------------------
   ShopConfigApiServiceProvider.php 2024-05-22
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2024 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Api\Modules\ShopConfig;

use Gambio\Core\Configuration\Services\ConfigurationService;
use Gambio\Api\Modules\ShopConfig\App\Actions\FetchShopConfigAction;
use Gambio\Api\Modules\ShopConfig\App\Actions\FetchShopConfigValueAction;
use Gambio\Api\Modules\ShopConfig\App\ShopConfigApiRequestValidator;

use Gambio\Core\Application\DependencyInjection\AbstractServiceProvider;

/**
 * Class ShopConfigApiServiceProvider
 *
 * @package Gambio\Api\Modules\ShopConfig
 */
class ShopConfigApiServiceProvider extends AbstractServiceProvider
{
    /**
     * @inheritDoc
     */
    public function provides(): array
    {
        return [
            FetchShopConfigAction::class,
            FetchShopConfigValueAction::class,
        ];
    }
    
    
    /**
     * @inheritDoc
     */
    public function register(): void
    {
        $this->application->registerShared(ShopConfigApiRequestValidator::class);
        
        $this->application->registerShared(FetchShopConfigAction::class)
            ->addArgument(ConfigurationService::class)
            ->addArgument(ShopConfigApiRequestValidator::class);
        $this->application->registerShared(FetchShopConfigValueAction::class)
            ->addArgument(ConfigurationService::class)
            ->addArgument(ShopConfigApiRequestValidator::class);
    }
}